/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.client.gui.handler;

import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.handler.AbstractRecipeBookGUIScreenHandler;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import satisfyu.beachparty.client.gui.handler.slot.IceSlot;
import satisfyu.beachparty.client.gui.handler.slot.TikiBarOutputSlot;
import satisfyu.beachparty.client.recipebook.group.MiniFridgeRecipeBookGroup;
import satisfyu.beachparty.recipe.MiniFridgeRecipe;
import satisfyu.beachparty.registry.ScreenHandlerTypesRegistry;

public class MiniFridgeGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    private final ContainerData delegate;

    public MiniFridgeGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(2));
    }

    public MiniFridgeGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerTypesRegistry.MINI_FRIDGE_GUI_HANDLER.get(), syncId, 2, playerInventory, inventory, propertyDelegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer((Container)playerInventory);
        this.delegate = propertyDelegate;
        this.m_38884_(this.delegate);
    }

    public int getShakeXProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = this.propertyDelegate.m_6413_(1);
        if (totalProgress == 0 || progress == 0) {
            return 0;
        }
        return progress * 22 / totalProgress + 1;
    }

    public int getShakeYProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = this.propertyDelegate.m_6413_(1);
        if (totalProgress == 0 || progress == 0) {
            return 0;
        }
        return progress * 19 / totalProgress + 1;
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_(new TikiBarOutputSlot(playerInventory.f_35978_, inventory, 0, 128, 42));
        this.m_38897_(new Slot(inventory, 1, 46, 27));
        this.m_38897_(new IceSlot(inventory, 2, 59, 43));
    }

    private void buildPlayerContainer(Container playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot(playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getCookProgress() {
        int i = this.delegate.m_6413_(0);
        int j = this.delegate.m_6413_(1);
        if (j == 0 || i == 0) {
            return 0;
        }
        return i * 24 / j;
    }

    public List<IRecipeBookGroup> getGroups() {
        return MiniFridgeRecipeBookGroup.FRIDGE_GROUPS;
    }

    public boolean hasIngredient(Recipe<?> recipe) {
        if (recipe instanceof MiniFridgeRecipe) {
            MiniFridgeRecipe miniFridgeRecipe = (MiniFridgeRecipe)recipe;
            for (Ingredient ingredient : miniFridgeRecipe.m_7527_()) {
                boolean found = false;
                for (Slot slot : this.f_38839_) {
                    if (!ingredient.test(slot.m_7993_())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getCraftingSlotCount() {
        return 2;
    }
}

